%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Recursive path tool

function [allRulePaths allDesignPaths allCostPaths] = designPathTool(designPathIn,remainingRulePath,fullRulePath,Tcost,Ttime,allRulePaths,allDesignPaths,allCostPaths,fuzzy)

% IF THERE ARE REMAINING RULES TO EXECUTE
if ~isempty(remainingRulePath)
    % identify current rule, remove from rule path
    currRule = remainingRulePath(1);
    rulePathOut = remainingRulePath;
    rulePathOut(1) = [];
    
    % identify current design and possible end states from current design
    currDesign = designPathIn(end);
    endStates = find(Tcost{currRule}(currDesign,:) > 0);
    
    % loop through possible end states as new design paths but ONLY IF D2
    % IS NOT ALREADY IN THE DESIGN PATH (this is always non-efficient for most applications)
    for d2 = endStates
        if isempty(intersect(designPathIn,d2))
            [allRulePaths allDesignPaths allCostPaths] = designPathTool([designPathIn d2],rulePathOut,fullRulePath,Tcost,Ttime,allRulePaths,allDesignPaths,allCostPaths,fuzzy);
        end
    end

else % IF THE FULL RULE PATH IS EXECUTED
    % identify start and finish states
    start = designPathIn(1);
    finish = designPathIn(end);
    
    % calculate total costs
    dollarcost = Tcost{fullRulePath(1)}(start,designPathIn(2));
    timecost = Ttime{fullRulePath(1)}(start,designPathIn(2));
    % go through steps incrementing cost for this design path
    for step = 2:length(fullRulePath)
        currRule = fullRulePath(step);
        d1 = designPathIn(step);
        d2 = designPathIn(step+1);
        dollarcost = dollarcost + Tcost{currRule}(d1,d2);
        timecost = timecost + Ttime{currRule}(d1,d2);
    end
    
    % append data to the appropriate location of allPaths cell arrays
    allCostPaths{start,finish} = [allCostPaths{start,finish} ; [dollarcost timecost]];
    allDesignPaths{start,finish} = [allDesignPaths{start,finish} ; designPathIn];
    allRulePaths{start,finish} = [allRulePaths{start,finish} ; fullRulePath];
    
    
    % recalculate pareto set of the costs if it is not the only one there
    % then trim out all nonpareto paths
    if size(allCostPaths{start,finish},1) > 1
        setIndex = gen_pareto_set(allCostPaths{start,finish},[0 0],1,false,fuzzy);
        allCostPaths{start,finish} = allCostPaths{start,finish}(setIndex,:);
        allDesignPaths{start,finish} = allDesignPaths{start,finish}(setIndex,:);
        allRulePaths{start,finish} = allRulePaths{start,finish}(setIndex,:);
    end
    % this update of allPaths is what is recorded as output
    
end

end